<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment;

use Erlage\Photogram\Settings;
use Erlage\Photogram\Constants\SystemConstants;
use Erlage\Photogram\Constants\ResponseConstants;
use Erlage\Photogram\Reflection\TraitReflectionClassName;

final class PostCommentValidator
{
    use TraitReflectionClassName;

    public static function displayText(string $displayText): string
    {
        if (\strlen($displayText) > Settings::getInt(SystemConstants::SETTING_MAX_LEN_POST_COMMENT_DISPLAY_TEXT))
        {
            return ResponseConstants::D_ERROR_POST_COMMENT_DISPLAY_TEXT_MAX_LEN_MSG;
        }

        if (\strlen($displayText) < Settings::getInt(SystemConstants::SETTING_MIN_LEN_POST_COMMENT_DISPLAY_TEXT))
        {
            return ResponseConstants::D_ERROR_POST_COMMENT_DISPLAY_TEXT_MIN_LEN_MSG;
        }

        return SystemConstants::OK;
    }
}
